# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdvaluespotcolor import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDSpotColorLibrary(SDAPIObject):
    """
    Spot color library. There is only one SDSpotColorLibrary, that you can retrieve from the SDApplication
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDSpotColorLibrary
        """
        super(SDSpotColorLibrary, self).__init__(APIContext, handle, *args, **kwargs)

    def findSpotColorByName(self, spotColorBookName : str, spotColorName : str) -> Optional[SDValueSpotColor]:
        """
        Find a spot color in a specific color book by name

        :param spotColorBookName: The color book name
        :param spotColorName: The color name
        """
        outSpotColor = ctypes.c_void_p()
        _res = self.mAPIContext.SDSpotColorLibrary_findSpotColorByName(self.mHandle, ctypes.create_string_buffer(spotColorBookName.encode('utf-8')), ctypes.create_string_buffer(spotColorName.encode('utf-8')), ctypes.byref(outSpotColor))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSpotColor, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSpotColor.value, ownHandle=True)

    def findClosestSpotColor(self, spotColorBookName : str, r : float, g : float, b : float) -> Optional[SDValueSpotColor]:
        """
        Return the closest spot color in a specific color book to a given RGB color

        :param spotColorBookName: The color book name
        :param r: The red component of the RGB color
        :param g: The green component of the RGB color
        :param b: The blue component of the RGB color
        """
        outSpotColor = ctypes.c_void_p()
        _res = self.mAPIContext.SDSpotColorLibrary_findClosestSpotColor(self.mHandle, ctypes.create_string_buffer(spotColorBookName.encode('utf-8')), r, g, b, ctypes.byref(outSpotColor))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSpotColor, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSpotColor.value, ownHandle=True)

    def getSpotColorBookName(self, spotColor : SDValueSpotColor) -> Optional[str]:
        """
        Return the name of the color book that owns the spot color

        :param spotColor: The spot color
        """
        outSpotColorBookName = ctypes.c_char_p()
        _res = self.mAPIContext.SDSpotColorLibrary_getSpotColorBookName(self.mHandle, spotColor.mHandle, ctypes.byref(outSpotColorBookName))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outSpotColorBookName.value.decode('utf-8') # type: ignore

    def getSpotColorName(self, spotColor : SDValueSpotColor) -> Optional[str]:
        """
        Return the spot color name

        :param spotColor: The spot color
        """
        outSpotColorName = ctypes.c_char_p()
        _res = self.mAPIContext.SDSpotColorLibrary_getSpotColorName(self.mHandle, spotColor.mHandle, ctypes.byref(outSpotColorName))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outSpotColorName.value.decode('utf-8') # type: ignore

